// TODO: https://st.yandex-team.ru/CRM-10289

import * as React from 'react';
import { Field } from 'react-final-form';
import { withAsyncFieldProvider } from 'lego/hoc/asyncField';
import TextArea from 'lego/final-form/TextArea';
import css from './styles.modules.scss';
import CommentBase, { Props, Render, RenderProps } from './CommentBase';
import { CommentWithPreventUnload } from './CommentBase.bundle';

const commentRender: Render = ({
  toolbar,
  files,
  autoFocus,
  placeholder,
  controlRef,
  maxLength,
}: RenderProps) => (
  <React.Fragment>
    <Field
      name="text"
      component={TextArea}
      componentClassName={css.input}
      placeholder={placeholder}
      autoFocus={autoFocus}
      controlRef={controlRef}
      maxLength={maxLength}
    />
    {files}
    {toolbar}
  </React.Fragment>
);

const Comment = React.forwardRef<CommentBase, Props>((props, ref) => (
  <CommentWithPreventUnload {...props} render={commentRender} innerRef={ref} />
));

export const CommentWithoutAsyncFieldProvider = Comment;

export default withAsyncFieldProvider()(Comment);
