import { ComponentType } from 'react';
import { compose } from '@bem-react/core';
import { withPreventUnload, WithPreventUnloadProps } from 'components/FinalForm/withPreventUnload';
import {
  withLocationChangeAutoSave,
  WithLocationChangeAutoSaveProps,
} from 'components/FinalForm/withLocationChangeAutoSave';
import CommentBase, { Props } from './CommentBase';

export const CommentWithPreventUnload = withPreventUnload(CommentBase);

export default compose(withLocationChangeAutoSave, withPreventUnload)(CommentBase) as ComponentType<
  Props & WithPreventUnloadProps & WithLocationChangeAutoSaveProps
>;
