// TODO: https://st.yandex-team.ru/CRM-10289

import React, { ComponentType } from 'react';
import { Field } from 'react-final-form';
import { withAsyncFieldProvider } from 'lego/hoc/asyncField';
import WFInput from 'lego/final-form/WFInput';
import { Render, RenderProps } from './CommentBase';
import CommentBase from './CommentBase.bundle';

const commentRender: Render = ({
  actions,
  files,
  autoFocus,
  placeholder,
  inviteeToggle,
  inviteesField,
  refTextComponent,
  addonToolbarBefore,
  addonToolbarAfter,
  addonToolbarRightAfter,
  actionsPosition,
  view,
}: RenderProps) => (
  <React.Fragment>
    <Field
      name="text"
      component={WFInput}
      placeholder={placeholder}
      autoFocus={autoFocus}
      actions={actions}
      afterButtonsPlaceholder={inviteeToggle}
      bottomButtonsPlaceholder={inviteesField}
      refComponent={refTextComponent}
      addonToolbarBefore={addonToolbarBefore}
      addonToolbarAfter={addonToolbarAfter}
      addonToolbarRightAfter={addonToolbarRightAfter}
      actionsPosition={actionsPosition}
      view={view}
    >
      {files}
    </Field>
  </React.Fragment>
);

const Comment = (props) => <CommentBase {...props} render={commentRender} />;

export const CommentWithoutAsyncFieldProvider = Comment;

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export default withAsyncFieldProvider()(Comment) as ComponentType<any>;
