import React from 'react';
import { reduxForm } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import RenderDatePicker from 'requestForms/components/RenderDatePicker';
import DatePicker from 'requestForms/components/FieldDatePicker';
import cx from 'classnames';
import cssBase from 'requestForms/BaseForm/style.scss';
import errorMessages from 'requestForms/BaseForm/errors';
import css from './style';

const validate = (values, props) => {
  const errors = {};
  const requiredFields = [props.name];
  requiredFields.forEach((field) => {
    if (!values[field]) {
      errors[field] = errorMessages.required;
    }
  });

  if (!errors[props.name]) {
    const mDate = Date.parse(values[props.name]);
    if (!mDate) {
      errors[props.name] = 'Некорректная дата. Формат даты: дд.мм.гггг';
    }
  }

  return errors;
};

const Form = (props) => {
  const { handleSubmit, pristine, submitting, valid, name } = props;

  return (
    <form className={cx(cssBase.form, css.form)} onSubmit={handleSubmit}>
      <div>
        <DatePicker
          name={name || 'date'}
          component={RenderDatePicker}
          size="s"
          maxLength={10}
          view="inline"
          autoFocus
        />
      </div>
      <Button size="xs" type="submit" view="action" disabled={pristine || submitting || !valid}>
        Сохранить
      </Button>
    </form>
  );
};

export default reduxForm({ validate, enableReinitialize: true })(Form);
