import React from 'react';
import { reduxForm, propTypes } from 'redux-form';
import errorMessages from 'requestForms/BaseForm/errors';
import * as Form from '../Base';

const countReg = /^[1-9][0-9]?$/;

const validate = (values) => {
  // eslint-disable-line no-unused-vars
  const errors = {};
  const requiredFields = ['queueId', 'clientId', 'categoryId', 'subjectId', 'count'];
  requiredFields.forEach((field) => {
    if (!values[field]) {
      errors._error = errorMessages.required; // eslint-disable-line no-underscore-dangle
    }
  });

  if (!countReg.test(values.count)) {
    errors.count = 'Число от 1 до 99';
  }

  return errors;
};

const NewTicketForm = (props) => {
  const { handleSubmit, pristine, submitting, valid, queueId, onCancel } = props;
  const isValid = !pristine && !submitting && valid;

  return (
    <Form.Form title="Создать новый тикет" onSubmit={handleSubmit}>
      <Form.Row label="Тема" component="subject" name="subjectId" required />
      <Form.Row label="Очередь" component="queue" name="queueId" required />
      <Form.Row name="clientId" component="client" label="Клиент" required />
      <Form.Row
        label="Категория"
        component="category"
        name="categoryId"
        queueId={queueId}
        required
      />
      <Form.Row label="Количество" component="TextInput" name="count" />
      <Form.Footer
        submitText="Создать"
        submitProps={{
          disabled: !isValid,
        }}
        cancelProps={{
          onClick: onCancel,
        }}
      />
    </Form.Form>
  );
};

NewTicketForm.propTypes = {
  ...propTypes,
};

export default reduxForm({ validate })(NewTicketForm);
