import { connect } from 'react-redux';
import { InjectView as Inject, NotificationBase as Base } from 'modules/notificationsUI';
import { history } from 'appHistory';

const mapDispatch = (dispatch, props) => {
  if (props.extra && props.extra.id) {
    return {
      actions: [
        {
          children: 'Открыть',
          onClick: () => history.push(`/ticket/${props.extra.id}`),
        },
      ],
    };
  }

  return null;
};

const NewTicketNotification = connect(null, mapDispatch)(Base);

Inject.addView('NEW_TICKET', NewTicketNotification);

export default NewTicketNotification;
