import React from 'react';
import { Field, reduxForm } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import css from 'requestForms/BaseForm/style.scss';
import { number, float } from 'requestForms/utils/patterns';
import TextInput from 'lego/redux-form/TextInput';
import errorMessages from 'requestForms/BaseForm/errors';
import formCss from './styles.modules.scss';

const validate = (values, props) => {
  const errors = {};
  const requiredFields = [props.name];
  requiredFields.forEach((field) => {
    if (!values[field]) {
      errors._error = errorMessages.required;
    }
  });

  if (props.isFloat) {
    if (values[props.name] && !float.test(values[props.name])) {
      errors._error = errorMessages.invalid;
    }
  } else if (values[props.name] && !number.test(values[props.name])) {
    errors._error = errorMessages.invalid;
  }

  return errors;
};

const Form = (props) => {
  const { handleSubmit, pristine, error, submitting, valid, maxLength, name } = props;
  return (
    <form className={cx(css.form)} onSubmit={handleSubmit}>
      <div>
        <Field
          name={name || 'number'}
          component={TextInput}
          type="text"
          maxLength={maxLength}
          size="s"
          autoFocus
        />
      </div>
      <div className={formCss.error}>{error}</div>
      <Button size="s" type="submit" view="action" disabled={pristine || submitting || !valid}>
        Сохранить
      </Button>
    </form>
  );
};

export default reduxForm({ validate })(Form);
