import React from 'react';
import PropTypes from 'prop-types';
import withDocumentEvents from 'utils/withDocumentEvents';
import Textinput from '@crm/components/dist/lego2/Textinput';
import { withAsyncFieldProvider, AsyncFormContext } from 'lego/hoc/asyncField';
import { CommentWithoutAsyncFieldProvider } from 'forms/Comment';

class ToggleComment extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      open: false,
    };
  }

  open = () => {
    this.setState({ open: true });
  };

  hide = () => {
    this.setState({ open: false });
  };

  handleDocumentKeydown = (event) => {
    if (
      !this.context &&
      this.state.open &&
      event.keyCode === 27 &&
      (this.props.hideOnOutsideClick || (this.form && this.form.pristine))
    ) {
      this.hide();
    }
  };

  handleDocumentMousedown = (event, isOutside) => {
    if (
      !this.context &&
      isOutside &&
      (this.props.hideOnOutsideClick || (this.form && this.form.pristine))
    ) {
      this.hide();
    }
  };

  handleFocus = () => {
    this.setState({ open: true });
  };

  render() {
    const { className, size, ...other } = this.props;

    return (
      <div className={className}>
        {this.state.open ? (
          <CommentWithoutAsyncFieldProvider
            {...other}
            onCancelClick={this.hide}
            onSuccess={this.hide}
            cancelButton
            focusOnMount
            ref={(form) => {
              this.form = form;
            }}
          />
        ) : (
          <Textinput
            hasClear={false}
            placeholder={other.placeholder}
            size={size}
            onFocus={this.handleFocus}
          />
        )}
      </div>
    );
  }
}

ToggleComment.contextType = AsyncFormContext;

ToggleComment.propTypes = {
  size: PropTypes.string,
  className: PropTypes.string,
  hideOnOutsideClick: PropTypes.bool,
};

ToggleComment.defaultProps = {
  size: 'xs',
  className: undefined,
  hideOnOutsideClick: false,
};

export default withAsyncFieldProvider()(
  withDocumentEvents({ events: ['keydown', 'mousedown'] })(ToggleComment),
);
