import React from 'react';
import hoistNonReactStatic from 'hoist-non-react-statics';

const loader = config => (WrappedComponent) => {
  class Loader extends React.Component {
    componentDidMount() {
      if (typeof this.props.onMount === 'function') {
        this.props.onMount(this.props);
      }
    }

    componentWillReceiveProps(nextProps) {
      if (typeof this.props.onReceiveProps === 'function') {
        this.props.onReceiveProps(nextProps, this.props);
      }
    }

    componentWillUnmount() {
      if (typeof this.props.onUnmount === 'function') {
        this.props.onUnmount(this.props);
      }
    }

    render() {
      if (!this.props.loaderRenderWrapped) {
        return null;
      }

      return <WrappedComponent {...this.props} />;
    }
  }

  hoistNonReactStatic(Loader, WrappedComponent);
  Loader.defaultProps = {
    loaderRenderWrapped: true,
    ...config,
  };
  return Loader;
};

export default loader;
