import React from 'react';
import { connect } from 'react-redux';
import hoistNonReactStatic from 'hoist-non-react-statics';
import { component as Modal, toggle } from 'containers/Modal';

const mapDispatch = (dispatch, props) => ({
  onCancel: () => {
    if (typeof props.onCancel === 'function') {
      props.onCancel();
    }
    return dispatch(toggle(props.name, false));
  },
  dispatch,
});

const modalForm = settings => WrappedComponent => {
  class ModalForm extends React.Component {
    onSubmitSuccess = (...args) => {
      if (typeof this.props.onSubmitSuccess === 'function') {
        this.props.onSubmitSuccess(...args);
      }

      this.close();
    };

    renderModal() {
      const { name, size, modalProps, onSubmitSuccess, formProps, ...props } = this.props;

      let computedSize = size;
      if (typeof size === 'function') {
        computedSize = size(this.props);
      }

      return (
        <Modal name={name} size={computedSize} {...modalProps}>
          <WrappedComponent
            name={name}
            form={name}
            {...formProps}
            {...props}
            onSubmitSuccess={this.onSubmitSuccess}
          />
        </Modal>
      );
    }

    open = () => {
      this.props.dispatch(toggle(this.props.name, true));
    };

    close = () => {
      this.props.dispatch(toggle(this.props.name, false));
    };

    render() {
      const { children } = this.props;
      const modal = this.renderModal();

      if (typeof children === 'function') {
        return children(modal, this.open);
      }

      return modal;
    }
  }

  const ConnectedModalForm = connect(null, mapDispatch, undefined, { forwardRef: true })(ModalForm);
  hoistNonReactStatic(ConnectedModalForm, WrappedComponent);
  ConnectedModalForm.defaultProps = {
    ...settings,
  };

  // build outer component to expose instance api
  return class ReduxModal extends React.Component {
    open() {
      this.wrapped.open();
    }

    close() {
      this.wrapped.close();
    }

    render() {
      return (
        <ConnectedModalForm
          {...this.props}
          ref={wrapped => {
            this.wrapped = wrapped;
          }}
        />
      );
    }
  };
};

export default modalForm;
