/**
 * Данный hoc позволяет переписать пропсы, полезно для redux-form
 * */
import React from 'react';
import PropTypes from 'prop-types';
import hoistNonReactStatic from 'hoist-non-react-statics';

const propsAdapter = config => (WrappedComponent) => {
  const PropsAdapter = ({ adapter, ...props }) => (
    <WrappedComponent {...adapter(props)} />
  );

  hoistNonReactStatic(PropsAdapter, WrappedComponent);
  PropsAdapter.propTypes = {
    adapter: PropTypes.func, // props => newProps
  };
  PropsAdapter.defaultProps = {
    ...config,
  };
  return PropsAdapter;
};

export default propsAdapter;
