import React, { ComponentType, FC } from 'react';
import { useSelector } from 'react-redux';
import { BackendEnv } from './withBackendEnv.types';

export function withBackendEnv<Props extends { env: BackendEnv }>(
  WrappedComponent: ComponentType<Props>,
) {
  const WithBackendEnv: FC<Omit<Props, 'env'>> = (props) => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const isTest = useSelector((state: any) => state.root.info.testMode);

    let env = BackendEnv.Prod;

    if (isTest) {
      env = BackendEnv.Test;
    }

    return <WrappedComponent {...(props as Props)} env={env} />;
  };

  return WithBackendEnv;
}
