import React from 'react';
import { worker } from './mocks/browser';
import { withLoad } from './withLoad';
import { TestComponent } from './TestComponent';

export default {
  title: 'Hocs/withLoad',
  decorators: [
    (Story) => {
      // Reset request handlers added in individual stories.
      worker?.start();
      worker?.resetHandlers();
      return <Story />;
    },
  ],
};

const LoadableTestComponent = withLoad(TestComponent);

export const Default = () => <LoadableTestComponent url="/load" />;

export const LoadWithError = () => <LoadableTestComponent url="/error" />;
