import React, { ComponentType, FC, useEffect, useState } from 'react';
import { get } from 'entry/api/common';
import { WithLoadProps, WithLoadInjectedProps } from './withLoad.types';

export const withLoad = <LoadData, OwnProps extends WithLoadInjectedProps<LoadData>>(
  WC: ComponentType<OwnProps>,
) => {
  const WithLoad: FC<WithLoadProps & Omit<OwnProps, keyof WithLoadInjectedProps<LoadData>>> = (
    props,
  ) => {
    const [data, setData] = useState<LoadData>();
    const [error, setError] = useState<Error>();
    const { url, passUrl, ...restProps } = props;
    let propsWithUrl;

    useEffect(() => {
      const promise = get<LoadData>({
        url,
      })
        .then((response) => {
          setData(response);
        })
        .catch((error) => {
          setError(error);

          throw error;
        });

      return () => {
        promise.cancel();
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [url]);

    if (error) {
      return <span>{error.message}</span>;
    }

    if (!data) {
      return null;
    }

    if (passUrl) {
      propsWithUrl = { url, ...restProps };
    }
    return <WC {...((propsWithUrl || (restProps as unknown)) as OwnProps)} data={data} />;
  };

  return WithLoad;
};
