import React, { useRef, ComponentType } from 'react';
import { useOverlay, UseOverlayOptions } from '@yandex-lego/components/useOverlay';

export function withOverlay<Props>(WrappedComponent: ComponentType<Props>) {
  const WithOverlay: React.FC<Props & Pick<UseOverlayOptions, 'visible' | 'onClose'>> = (props) => {
    const { visible, onClose } = props;
    const contentRef = useRef(null);

    useOverlay({
      visible,
      onClose,
      essentialRefs: [contentRef],
    });

    return <WrappedComponent ref={contentRef} {...props} />;
  };

  return WithOverlay;
}
