import * as React from 'react';
import ComboInput from 'lego/components/ComboInput';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';

interface Props {
  name: string;
  size: LegoSizeProp;
  className: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onChange: any;
  forceAccountTypes: string[];
  placeholder: React.ReactNode;
  hasNullAccount?: boolean;
}

const getName = (value) => {
  let result;
  if (value) {
    if (value.info) {
      result = value.info.name;
    } else {
      result = value.name;
    }
  }

  return result;
};

const AccountInput = (props: Props) => {
  const {
    name,
    value,
    onChange,
    className,
    size,
    forceAccountTypes,
    placeholder,
    hasNullAccount = false,
  } = props;

  return (
    <ClientFind
      name={name}
      onSubmit={onChange}
      newClient={hasNullAccount}
      forceAccountTypes={forceAccountTypes}
    >
      {(modal, open) => (
        <ComboInput
          className={className}
          onChange={open}
          onClear={() => onChange(null)}
          value={getName(value)}
          changeNode={modal}
          size={size}
          placeholder={placeholder}
          view="default"
        />
      )}
    </ClientFind>
  );
};

export default AccountInput;
