import React from 'react';
import Dropzone, { DropzoneOptions } from 'react-dropzone';
import { DropTarget } from 'react-dnd';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import FilesList, { DNDType } from 'components/FilesList';
import createI18N from '@yandex-int/i18n';
import Spinner from 'components/Spinner';
import * as keyset from './AttachFiles.i18n';
import css from './AttachFiles.modules.scss';
import { BackendFile } from './types';

const i18n = createI18N(keyset);
const i18nSelectFiles = i18n('selectFiles');
const i18nOrDragIt = i18n('orDragIt');

interface Props {
  files?: BackendFile[];
  onDrop: DropzoneOptions['onDrop'];
  onRemove?: (id: number) => void;
  onFilesUpdate: (idsToLink: number[], idsToRemove: number[]) => void;
  className?: string;
  maxHeight?: number;
  isFetch?: boolean;
}

const AttachTarget = {
  drop: (props: Props, monitor) => {
    const fileId = monitor.getItem().id;
    props.onFilesUpdate([fileId], []);
  },
};

const collect = (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isFileOver: monitor.isOver(),
});

const AttachFiles = (props: Props & ReturnType<typeof collect>) => {
  const { files, onDrop, onRemove, className, maxHeight, isFetch, isFileOver } = props;

  return props.connectDropTarget(
    <div>
      <Dropzone onDrop={onDrop} noClick noKeyboard>
        {({ getRootProps, getInputProps, isDragActive, open }) => (
          <div
            className={cx(css.root, className, { [css.root_active]: isDragActive || isFileOver })}
            style={{ maxHeight }}
            {...getRootProps()}
          >
            <input {...getInputProps()} />
            <div className={css.header}>
              <Button size="xs" view="pseudo" onClick={open}>
                {i18nSelectFiles}
              </Button>{' '}
              {i18nOrDragIt}
            </div>
            <FilesList
              rootClassName={css.files}
              files={files}
              isInline
              onRemove={onRemove}
              inFileBox
            />
            <Spinner visible={isFetch} overlay asComponent delay />
          </div>
        )}
      </Dropzone>
    </div>,
  );
};

export default DropTarget(DNDType, AttachTarget, collect)(AttachFiles);
