import { post, apiUploadFilesCall, deleteRequest } from 'api/common';

/**
 * @param args={objectName, objId, containerId, files[]}
 * @retunr {objId, containerId, files[]}
 * */
export const add = (args) =>
  apiUploadFilesCall(
    `/actions/${args.objectName}/file/add`,
    {
      ...args,
      objectName: undefined,
    },
    false,
  );

export const remove = (args) =>
  post({
    url: `/actions/${args.objectName}/file/remove`,
    data: { ...args, objectName: undefined },
    global: false,
  });

export const update = (args) =>
  post({
    url: `/actions/${args.objectName}/file/updateLinks`,
    data: { ...args, objectName: undefined },
    global: false,
  });

export const removeFileFromContainer = (args) =>
  deleteRequest({
    url: `/containers/${args.containerId}/files/${args.fileId}`,
    global: false,
  });
