import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import css from './ButtonGroup.scss';

interface Props {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  items: any[];
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any[];
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onChange: (value: any[]) => {};
  width: string;
  className?: string;
}

export const getPin = (length, index) => {
  if (length > 1) {
    if (index === 0) {
      return 'round-clear';
    }

    if (index === length - 1) {
      return 'brick-round';
    }
  }

  if (length === 1) {
    return undefined;
  }

  return 'brick-clear';
};

class ButtonGroup extends React.Component<Props> {
  public static defaultProps = {
    value: [],
  };

  private handleChange = (e, value) => {
    const { value: inputValue } = this.props;
    let nextValue;
    if (inputValue instanceof Array) {
      if (inputValue.includes(value)) {
        nextValue = inputValue.filter((item) => item !== value);
      } else {
        nextValue = inputValue.concat(value);
      }
    } else {
      nextValue = [value];
    }
    this.props.onChange(nextValue);
  };

  private createClickHandle = (value) => (e) => {
    this.handleChange(e, value);
  };

  public render() {
    const { items, value: inputValue, width, className, ...passPropsThrough } = this.props;

    return (
      <span className={`${css.b} ${css[`b_width_${width}`]}`}>
        {items.map(({ value, text, title, icon }, index) => (
          <Button
            key={value}
            onClick={this.createClickHandle(value)}
            view={inputValue.includes(value) ? 'action' : undefined}
            pin={getPin(items.length, index)}
            title={title}
            icon={icon}
            {...passPropsThrough}
            className={cx(css.b__button, className)}
          >
            {text}
          </Button>
        ))}
      </span>
    );
  }
}

export default ButtonGroup;
