import React from 'react';
import Button, { ButtonViewProp } from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import DropdownMenu from 'lego/components/DropdownMenu';
import css from './ButtonGroup.scss';

export interface Props {
  // eslint-disable-next-line
  items: any[];
  // eslint-disable-next-line
  value: any[];
  // eslint-disable-next-line
  onChange?: (value: any[]) => void;
  // eslint-disable-next-line
  onClick?: (e: React.SyntheticEvent<HTMLButtonElement>, value: any[]) => void;
  onStateChange?: (isVisible: boolean) => void;
  width?: string;
  size?: LegoSizeProp;
  view?: ButtonViewProp;
  getWrapRef?: React.Ref<HTMLSpanElement>;
  // eslint-disable-next-line
  style?: any;
  disabled?: boolean;
}

const getPin = (length: number, index: number) => {
  if (length > 1) {
    if (index === 0) {
      return 'round-clear';
    }

    if (index === length - 1) {
      return 'brick-round';
    }
  }

  if (length === 1) {
    return undefined;
  }

  return 'brick-clear';
};

class ButtonGroup extends React.Component<Props> {
  public static defaultProps = {
    value: [],
    width: '',
  };

  // eslint-disable-next-line
  private handleChange = (e: React.MouseEvent<HTMLButtonElement>, value: any) => {
    if (typeof this.props.onChange === 'function') {
      const { value: inputValue } = this.props;
      let nextValue;
      if (inputValue instanceof Array) {
        if (inputValue.includes(value)) {
          nextValue = inputValue.filter((item) => item !== value);
        } else {
          nextValue = inputValue.concat(value);
        }
      } else {
        nextValue = [value];
      }

      this.props.onChange(nextValue);
    }

    if (typeof this.props.onClick === 'function') {
      this.props.onClick(e, value);
    }
  };

  private handleMenuClick = (e: React.MouseEvent<HTMLButtonElement>, value: string) => {
    this.handleChange(e, value);
  };

  // eslint-disable-next-line
  private createClickHandle = (value: any) => (e: React.MouseEvent<HTMLButtonElement>) => {
    this.handleChange(e, value);
  };

  public render() {
    const {
      items,
      value: inputValue,
      width,
      size,
      view,
      getWrapRef,
      style,
      disabled,
      onClick,
      onChange,
      onStateChange,
      ...passPropsThrough
    } = this.props;

    return (
      <span className={`${css.b} ${css[`b_width_${width}`]}`} ref={getWrapRef} style={style}>
        {items.map(({ val, text, title, icon, arrow, items: subItems }, index) =>
          Array.isArray(subItems) ? (
            <DropdownMenu
              key={val}
              arrow={arrow}
              pin={getPin(items.length, index)}
              size={size}
              theme={view}
              text={text}
              icon={icon}
              items={subItems}
              onClick={this.handleMenuClick}
              onStateChange={onStateChange}
              disabled={disabled}
            />
          ) : (
            <Button
              key={val}
              onClick={this.createClickHandle(val)}
              pin={getPin(items.length, index)}
              className={css.b__button}
              title={title}
              size={size}
              view={inputValue.includes(val) ? 'action' : view}
              disabled={disabled}
              iconRight={icon ? (iconCls) => <Icon className={iconCls} {...icon} /> : undefined}
              {...passPropsThrough}
            >
              {text}
            </Button>
          ),
        )}
      </span>
    );
  }
}

export default ButtonGroup;
