import * as React from 'react';
import Button, { ButtonProps } from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';

interface Props extends ButtonProps {
  open?: boolean;
}

const ButtonToggle = ({ open, ...other }: Props) => (
  <Button
    iconRight={(iconCls) => (
      <Icon className={iconCls} type="arrow" direction={open ? 'top' : 'bottom'} />
    )}
    {...other}
  />
);

export default ButtonToggle;
