import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Toolbar from 'components/Toolbar';
import CheckBoxGroupItem from './CheckBoxGroupItem';

class CheckBoxGroup extends React.PureComponent {
  static defaultProps = {
    items: [],
    value: [],
    size: 's',
    component: CheckBoxGroupItem,
  };

  handleOnChange = (value) => {
    const { onChange } = this.props;

    if (typeof onChange === 'function') {
      onChange(value);
    }
  };

  handleOnChangeCheckbox = (event) => {
    const { value } = this.props;
    const { checked, name } = event.target;
    const parsedId = parseInt(name, 10);

    let newValue;
    if (checked) {
      newValue = Array.isArray(value) ? value.concat([parsedId]) : [parsedId];
    } else {
      newValue = Array.isArray(value) ? value.filter((v) => v !== parsedId) : [];
    }

    this.handleOnChange(newValue);
  };

  selectAll = () => {
    const { items } = this.props;

    this.handleOnChange(items.map((item) => item.id));
  };

  deselectAll = () => {
    this.handleOnChange([]);
  };

  render() {
    const { value, size, component } = this.props;

    const mapValue = new Map();
    if (Array.isArray(value)) {
      value.forEach((id) => {
        mapValue.set(id, true);
      });
    }

    return (
      <div>
        <Toolbar>
          <Button size={size} onClick={this.selectAll}>
            Выбрать все
          </Button>
          <Button size={size} onClick={this.deselectAll}>
            Снять все
          </Button>
        </Toolbar>
        <div>
          {this.props.items.map((item) =>
            React.createElement(component, {
              key: item.id,
              item,
              value: mapValue.get(item.id),
              onChange: this.handleOnChangeCheckbox,
              size,
            }),
          )}
        </div>
      </div>
    );
  }
}

export default CheckBoxGroup;
