import React from 'react';
import Checkbox from '@crm/components/dist/lego2/Checkbox';
import css from './CheckBoxGroupItem.scss';

const CheckBoxGroupItem = (props) => {
  const { item, size, value, onChange } = props;

  return (
    <div className={css.b}>
      <div className={css.b__checkbox}>
        <Checkbox size={size} name={item.id} onChange={onChange} checked={value} isEventValue>
          {item.name}
        </Checkbox>
      </div>
      <div className={css.b__subName}>{item.subName}</div>
    </div>
  );
};

export default CheckBoxGroupItem;
