import React from 'react';
import Button from '@crm/components/dist/lego2/Button';

class CheckButton extends React.Component {
  handleChange = (event) => {
    const { value, onChange } = this.props;

    if (onChange) {
      onChange(!value, event);
    }
  };

  render() {
    const { onChange, value, ...other } = this.props;

    return <Button view={value ? 'action' : 'pseudo'} {...other} onClick={this.handleChange} />;
  }
}

export default CheckButton;
