import React, { Component } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './styles.modules.scss';

export default class ColorPicker extends Component {
  static propTypes = {
    className: PropTypes.string,
    name: PropTypes.string,
    onChange: PropTypes.func,
    value: PropTypes.any, // eslint-disable-line react/forbid-prop-types
    selectable: PropTypes.bool,
    colors: PropTypes.instanceOf(Array),
  };

  static defaultProps = {
    className: undefined,
    name: undefined,
    onChange: undefined,
    value: undefined,
    selectable: true,
    colors: [
      ['#31c73b', '#28a931', '#1d8925', '#136619'],
      ['#7cc3c4', '#67a3a4', '#508182', '#395e5f'],
      ['#5a8eff', '#5080e7', '#456ec8', '#385ca8'],
      ['#ba99ff', '#a488e2', '#8e75c4', '#7760a4'],
      ['#a8bcce', '#8e9faf', '#73818e', '#57616c'],
      ['#c1be00', '#a19f00', '#807e00', '#5c5a00'],
      ['#f99000', '#db7f00', '#bb6c00', '#9c5800'],
      ['#ff8985', '#ff3f30', '#f32300', '#d51e00'],
    ],
  };

  handleChange = e => {
    const { onChange } = this.props;
    if (typeof onChange === 'function') {
      onChange(e);
    }
  };

  renderColors = () => {
    const { colors } = this.props;
    const rows = [];

    colors.forEach(shades => {
      rows.push(
        <span key={shades[0]} className={css.paletteColor}>
          {this.renderShades(shades)}
        </span>,
      );
    });

    return rows;
  };

  renderShades = shades => {
    const { value, selectable, name } = this.props;
    const rows = [];

    shades.forEach(shade => {
      const val = shade.replace('#', '');

      if (selectable) {
        rows.push(
          <label
            key={val}
            className={cx(css.paletteShade, css.isSelectable)}
            style={{ backgroundColor: shade }}
          >
            <input
              type="radio"
              name={name}
              value={val}
              onChange={this.handleChange}
              checked={value === val}
            />
            {value === val && <span className={css.paletteShadeSelected}>✓</span>}
          </label>,
        );
      } else {
        rows.push(
          <span key={val} className={css.paletteShade} style={{ backgroundColor: shade }}>
            &nbsp;
          </span>,
        );
      }
    });

    return rows;
  };

  render() {
    return (
      <div className={cx(this.props.className, css.palette)}>
        <span
          className={css.paletteColors}
          ref={input => {
            this.node = input;
          }}
        >
          {this.renderColors()}
        </span>
      </div>
    );
  }
}
