import * as React from 'react';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import Button, { ButtonViewProp } from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import withRefSupport from 'utils/withRefSupport';

interface Props {
  value: unknown;
  view?: ButtonViewProp;
  size: LegoSizeProp;
  placeholder?: React.ReactNode;
  onChange: () => void;
  changeNode: React.ReactNode;
  onClear: () => void;
  clearNode?: React.ReactNode;
  className?: string;
  innerRef?: React.Ref<HTMLElement>;
}

const rootStyle = { display: 'inline-flex', maxWidth: '100%' };
const style = { minWidth: 0 };

const ComboInput = (props: Props) => {
  const {
    value,
    placeholder = 'Выбрать',
    onChange,
    onClear,
    changeNode,
    clearNode,
    size,
    view = 'pseudo',
    innerRef,
    ...passPropsThrough
  } = props;

  return (
    <span style={rootStyle} {...passPropsThrough} ref={innerRef}>
      <Button
        size={size}
        view={view}
        onClick={onChange}
        pin={value ? 'round-brick' : undefined}
        width="auto"
        style={style}
      >
        {value != null ? value : placeholder}
        {changeNode}
      </Button>
      {Boolean(value) && (
        <Button
          size={size}
          view={view}
          onClick={onClear}
          pin="clear-round"
          icon={
            clearNode == null ? (iconCls) => <Icon className={iconCls} type="cross" /> : undefined
          }
        >
          {clearNode}
        </Button>
      )}
    </span>
  );
};

export default withRefSupport(ComboInput) as React.ComponentType<Props>;
