import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Popup from '@crm/components/dist/lego2/Popup';
import Icon from '../Icon';

interface Props {
  children: React.ReactNode;
  onStateChange?: (isVisible: boolean) => void;
  arrow: boolean;
}

interface State {
  visible: boolean;
}

class Dropdown2 extends React.Component<Props, State> {
  public static defaultProps = {
    arrow: true,
  };

  // eslint-disable-next-line
  public static Button: any;

  // eslint-disable-next-line
  public static Popup: any;

  public state = {
    visible: false,
  };

  private ref = React.createRef();

  private toggle = () => {
    this.setState(
      (state) => ({ visible: !state.visible }),
      () => {
        this.props.onStateChange?.(this.state.visible);
      },
    );
  };

  public render() {
    const children = React.Children.toArray(this.props.children);

    const switcher = React.cloneElement(children[0] as React.ReactElement, {
      onClick: this.toggle,
      ref: this.ref,
      iconRight:
        this.props.arrow &&
        ((iconCls) => (
          <Icon
            className={iconCls}
            type="arrow"
            direction={this.state.visible ? 'top' : 'bottom'}
          />
        )),
    });
    const popup = React.cloneElement(children[1] as React.ReactElement, {
      visible: this.state.visible,
      target: 'anchor',
      anchor: this.ref,
      onClose: this.toggle,
    });

    return (
      <React.Fragment>
        {switcher}
        {popup}
      </React.Fragment>
    );
  }
}

Dropdown2.Button = Button;
Dropdown2.Popup = Popup;

export default Dropdown2;
