import React from 'react';
import Dropdown2 from 'lego/components/Dropdown2';
import Button from '@crm/components/dist/lego2/Button';
import Menu from '@crm/components/dist/lego2/Menu';
import Icon from 'lego/components/Icon';

class DropdownMenu extends React.Component {
  static defaultProps = {
    directions: 'bottom',
  };

  dropdown = React.createRef();

  handleClick = (...args) => {
    if (this.props.onClick) {
      this.props.onClick(...args);

      this.dropdown.current.toggle();
    }
  };

  handleChange = (...args) => {
    if (this.props.onChange) {
      this.props.onChange(...args);

      this.dropdown.current.toggle();
    }
  };

  render() {
    const {
      arrow,
      pin,
      size,
      theme,
      view,
      text,
      icon,
      items,
      mode,
      maxHeight,
      disabled,
      popupClassName,
      directions,
      onStateChange,
    } = this.props;

    const shouldRenderMenu = Boolean(Array.isArray(items) && items.length);

    return (
      <Dropdown2 arrow={arrow} ref={this.dropdown} onStateChange={onStateChange}>
        <Button pin={pin} size={size} view={theme || view} disabled={disabled}>
          {icon ? <Icon {...icon} /> : text}
        </Button>
        <Dropdown2.Popup
          maxHeight={maxHeight}
          cls={popupClassName}
          overflow="auto"
          directions={directions}
        >
          {shouldRenderMenu && (
            <Menu
              items={items.map((item) => ({
                value: item.val,
                content: item.text,
              }))}
              size={size}
              style={{ maxHeight }}
              onClick={this.handleClick}
              onChange={this.handleChange}
              mode={mode}
              disabled={disabled}
            />
          )}
        </Dropdown2.Popup>
      </Dropdown2>
    );
  }
}

export default DropdownMenu;
