import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button/Button';
import css from './FileInput.modules.scss';

class FileInput extends React.Component {
  handleClick = () => {
    this.input.click();
  };

  render() {
    const {
      className,
      wrapComponent,
      wrapComponentProps,
      inputComponent,
      inputComponentProps,
      children,
      ...passPropsThrough
    } = this.props;

    return createElement(
      wrapComponent,
      { className: cx(className, css.FileInput), ...wrapComponentProps },
      [
        createElement(
          inputComponent,
          { ...inputComponentProps, onClick: this.handleClick, key: '0' },
          children,
        ),
        <input
          value=""
          key="1"
          ref={(node) => {
            this.input = node;
          }}
          className={css.FileInput__input}
          type="file"
          {...passPropsThrough}
        />,
      ],
    );
  }
}

FileInput.propTypes = {
  className: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  wrapComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
  inputComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
  inputComponentProps: PropTypes.objectOf(PropTypes.any),
  wrapComponentProps: PropTypes.objectOf(PropTypes.any),
  children: PropTypes.node,
};

FileInput.defaultProps = {
  className: null,
  wrapComponent: 'div',
  inputComponent: Button,
  inputComponentProps: null,
  wrapComponentProps: null,
  children: null,
};

export default FileInput;
