import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from 'lego/components/Icon';
import css from './FilterToggle.modules.scss';

interface Props {
  value: boolean;
  onChange: (value: boolean) => {};
}

class FilterToggle extends React.Component<Props> {
  private handleOnChange = () => {
    const { value, onChange } = this.props;
    if (typeof onChange === 'function') {
      onChange(!value);
    }
  };

  public render() {
    const { value, ...passPropsThrough } = this.props;

    return (
      <Button
        onClick={this.handleOnChange}
        className={value ? undefined : css.FilterToggle_disabled}
        view="pseudo"
        size="s"
        pin="brick-clear"
        title={value ? 'Поиск с фильтрами' : 'Поиск без фильтров'}
        icon={(iconCls) => <Icon className={iconCls} pack={Icon.PACKS.FONTAWESOME} icon="filter" />}
        {...passPropsThrough}
      />
    );
  }
}

export default FilterToggle;
