import React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Menu from '@crm/components/dist/lego2/Menu';
import css from './FilteredMenu.scss';

/* eslint-disable @typescript-eslint/no-explicit-any */
interface Props {
  onChange: (id: number, item: any) => void;
  items: any[];
  search?: string;
  onSearch?: (text: string) => void;
  autoFocus?: boolean;
  popup?: boolean;
  children?: React.ReactNode;
  getScrollNode?: React.Ref<HTMLDivElement>;
}

const FilteredMenu = (props: Props) => {
  const { onChange, search, items, onSearch, autoFocus, popup, children, getScrollNode } = props;

  let className = css.b;
  if (popup) {
    className += ` ${css.b_popup}`;
  }

  const menuItems = items.map((item) => ({
    value: item,
    content: item.name,
  }));

  return (
    <div ref={getScrollNode} className={className}>
      {onSearch && (
        <div className={css.b__search}>
          <Textinput placeholder="Поиск" onChange={onSearch} value={search} autoFocus={autoFocus} />
        </div>
      )}
      <Menu
        items={menuItems}
        onChange={(event) => onChange(event.target.value.id, event.target.value)}
      />
      {children}
    </div>
  );
};

FilteredMenu.defaultProps = {
  items: [],
  autoFocus: false,
};

export default FilteredMenu;
