import React from 'react';
import isPromise from 'is-promise';
import debounce from 'lodash/debounce';
import FilteredMenu from './FilteredMenu';

class FilteredMenuContainer extends React.Component {
  constructor(props) {
    super(props);

    if (props.delay) {
      this.getItemsDebounce = debounce(this.getItems, props.delay);
    } else {
      this.getItemsDebounce = this.getItems;
    }

    this.state = {
      search: '',
      items: [],
    };
  }

  componentDidMount() {
    this.getItems(this.state.text);
  }

  componentWillUnmount() {
    this.cancelLastRequest();
  }

  setItems = items => {
    this.setState({ items });
  };

  getItems = text => {
    this.cancelLastRequest();
    const result = this.props.provider(text);
    if (isPromise(result)) {
      this.lastRequest = result;
      result
        .finally(() => {
          this.lastRequest = null;
        })
        .then(response => {
          this.setItems(response);
        });
    } else {
      this.setItems(result);
    }
  };

  cancelLastRequest = () => {
    if (this.lastRequest) {
      this.lastRequest.cancel();
    }
  };

  handleSearch = text => {
    this.setState({ search: text });
    this.getItemsDebounce(text);
  };

  render() {
    const { provider, ...forwardProps } = this.props;

    return <FilteredMenu {...this.state} {...forwardProps} onSearch={this.handleSearch} />;
  }
}

export default FilteredMenuContainer;
