import React from 'react';
import isPromise from 'is-promise';
import Button from '@crm/components/dist/lego2/Button';
import Popup2 from '@crm/components/dist/lego2/Popup';
import getDisplayName from 'utils/getDisplayName';

const withPopupInput = (config) => (WrappedComponent) => {
  class WithPopupInput extends React.Component {
    static defaultProps = {
      toggleNode: <Button>change</Button>,
      ...config,
    };

    constructor(props) {
      super(props);

      this.toggleNode = React.createRef();

      this.state = {
        visible: false,
      };
    }

    componentWillUnmount() {
      this.cancelLastRequest();
    }

    hide = () => {
      this.setState({ visible: false });
    };

    show = () => {
      this.setState({ visible: true });
    };

    cancelLastRequest = () => {
      if (this.lastPromise) {
        this.lastPromise.cancel();
      }
    };

    handleChange = (...args) => {
      const { onChange } = this.props;

      if (typeof onChange === 'function') {
        const result = onChange(...args);
        if (isPromise(result)) {
          this.lastPromise = result;
          result.then((data) => {
            this.lastPromise = null;
            this.hide();
            return data;
          });
        } else {
          this.hide();
        }
      }
    };

    render() {
      const { onChange, toggleNode, ...forwardProps } = this.props;

      const toggleNodeWithProps = React.cloneElement(toggleNode, {
        onClick: this.show,
        ref: this.toggleNode,
      });

      return (
        <React.Fragment>
          {toggleNodeWithProps}
          <Popup2
            visible={this.state.visible}
            anchor={this.toggleNode}
            target="anchor"
            onClose={this.hide}
          >
            <WrappedComponent onChange={this.handleChange} {...forwardProps} />
          </Popup2>
        </React.Fragment>
      );
    }
  }

  WithPopupInput.displayName = `WithPopupInput(${getDisplayName(WrappedComponent)})`;

  return WithPopupInput;
};

export default withPopupInput;
