import React, { FC } from 'react';
import cx from 'classnames';
import css from './FormTextAlign.module.css';
import { FormTextAlignProps } from './FormTextAlign.types';

export const FormTextAlign: FC<FormTextAlignProps> = (props) => {
  const { as: Component = 'span', size = 'm', className, ...otherProps } = props;

  return (
    <Component
      className={cx(className, css.FormTextAlign, css[`FormTextAlign_size_${size}`])}
      {...otherProps}
    />
  );
};
