export default {
  formatToBackend(value, initValue) {
    const backendValue = Array.isArray(value) ? [].concat(value) : [];

    (initValue || []).forEach((item) => {
      const grantIsPresent = Array.isArray(value) && value.some(i => (
        (item.userId && item.userId === i.userId) ||
        (item.groupId && item.groupId === i.groupId)
      ));

      if (!grantIsPresent) {
        backendValue.push({ ...item, hasRemoved: true });
      }
    });

    return backendValue;
  },
  validate(value) {
    return Array.isArray(value) && value.length;
  },
};
