import { createElement } from 'react';
import IconCallPersonal from 'components/Icons/IconCallPersonal';
import bemMixToClassName, { Mix } from 'lego/utils/bemMixToClassName';
import LegoIcon from '@crm/components/dist/lego2/Icon';
import { IIconProps } from '@yandex-lego/components/Icon/desktop/bundle';
import CustomIcon from 'components/Icons/Icon';
import IconSvg, { Props as IconSvgProps } from './IconSvg';
import './Icon.scss';

interface CommonProps {
  className?: string;
  pack: string;
  size: string;
  mix?: Mix[];
  type?: 'svg' | 'personal-call' | IIconProps['type'];
  icon: string;
  direction?: IIconProps['direction'];
  glyph?: IIconProps['glyph'];
}

interface PackIconProps {
  pack: string;
}

type IconProps = (PackIconProps | IconSvgProps) & CommonProps;

const Icon = (props: IconProps) => {
  const { type, pack, size, className: cls, mix, ...passPropsThrough } = props;

  if (pack) {
    const clsMix = bemMixToClassName(mix);
    const className = `icon_size_${size} button2__icon ${cls} ${clsMix}`;
    return createElement(CustomIcon, { className, pack, fix: true, ...passPropsThrough });
  }

  if (type === 'svg') {
    const clsMix = bemMixToClassName(mix);
    const className = `icon_size_${size} button2__icon button2__svg ${cls} ${clsMix}`;
    return createElement(IconSvg, { className, ...passPropsThrough });
  }

  if (type === 'personal-call') {
    const clsMix = bemMixToClassName(mix);
    const className = `icon_size_${size} button2__icon ${cls} ${clsMix}`;
    return createElement(IconCallPersonal, { className, ...passPropsThrough });
  }

  return createElement(LegoIcon, {
    className: props.className,
    type: props.type as IIconProps['type'],
    direction: props.direction,
    glyph: props.glyph,
  });
};

Icon.displayName = 'icon';
Icon.PACKS = CustomIcon.PACKS;

export default Icon;
