import React from 'react';
import svg from './svg';
import css from './Icon.scss';

export interface Props {
  icon: string;
  className?: string;
  mode?: string;
}

const IconSvg = (props: Props) => {
  const { icon, className, mode, ...passPropsThrough } = props;

  return (
    <span className={`${css.IconSvg} ${className}`} {...passPropsThrough}>
      <span className={css.IconSvg__wrapWidth}>
        <span className={css.IconSvg__wrap}>{React.createElement(svg[icon], { mode })}</span>
      </span>
    </span>
  );
};

export default IconSvg;
