import React from 'react';

const THEME = {
  color: {
    '0': 'none',
    '1': '#1B4A80',
    '2': '#2567B3',
    '3': '#338EF5',
    '4': '#2567B3',
    '5': '#2567B3',
  },
  grey: {},
};

interface Props {
  mode: string;
}

const StarTrek = (props: Props) => {
  const { mode, ...passPropsThrough } = props;

  const colors = THEME[mode];

  return (
    <svg {...passPropsThrough} xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
      <g fill={colors[1]}>
        <rect width="8" height="8" x="12" y="20" fill={colors[1]} />
        <rect width="8" height="8" x="12" y="12" fill={colors[2]} />
        <rect width="8" height="8" x="12" y="4" fill={colors[3]} />
        <rect width="8" height="8" x="4" y="4" fill={colors[4]} />
        <rect width="8" height="8" x="20" y="4" fill={colors[5]} />
      </g>
    </svg>
  );
};

StarTrek.defaultProps = {
  mode: 'color',
};

export default StarTrek;
