import React from 'react';
import cx from 'classnames';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Text } from '@crm/components/dist/lego2/Text';
import css from './Label.scss';

export interface LabelProps {
  size?: string;
  className?: string;
  tone?: string;
  required?: boolean;
  optional?: boolean;
  children?: React.ReactNode;
  hasLine?: boolean;
  color?: 'gray';
}

const Label: React.FC<LabelProps> = (props) => {
  const {
    size,
    children,
    className,
    tone,
    required,
    optional,
    hasLine,
    color,
    ...passProps
  } = props;

  const cls = cx(className, css.b, css[`b_tone_${tone}`], css[`b_color_${color}`], {
    [css.b_hasLine]: hasLine,
  });

  return (
    <FormTextAlign as="label" size={size} className={cls} {...passProps}>
      <span className={css.b__text}>
        <Text color="secondary" typography="body-long-m" weight="medium">
          {children}&nbsp;
        </Text>
        {required && (
          <>
            <span title="Обязательное поле" className={css.b__requiredStar}>
              *
            </span>
          </>
        )}
        {optional && <span className={css.b__optional}> (дополнительно)</span>}
      </span>
    </FormTextAlign>
  );
};

Label.defaultProps = {
  size: 's',
  tone: 'white',
  hasLine: true,
};

export default Label;
