import React from 'react';

const getPin = (length, index) => {
  if (length > 1) {
    if (index === 0) {
      return 'round-clear';
    }

    if (index === length - 1) {
      return 'brick-round';
    }
  }

  if (length === 1) {
    return 'round-round';
  }

  return 'brick-clear';
};

const PinGroup = ({ children }) => {
  let newChildren = React.Children.toArray(children).filter(child => child);

  const count = newChildren.length;

  newChildren = newChildren.map((child, index) => {
    return React.cloneElement(child, {
      pin: getPin(count, index),
    });
  });

  return <React.Fragment>{newChildren}</React.Fragment>;
};

export default PinGroup;
