import * as React from 'react';
import TreeInput from './TreeInput';

export const getSlugId = entity => {
  if (entity.type === 1) {
    return entity.id;
  }

  return `type${entity.type}_id${entity.id}`;
};
const canItemClick = node => !!node.type;

const StaffUserInput = props => (
  <TreeInput
    endpoint="/view/staff/user/tree?part=all"
    getSlugId={getSlugId}
    canItemClick={canItemClick}
    {...props}
  />
);

export default StaffUserInput;
