import * as React from 'react';
import SuggestDefault from './SuggestDefault';
import SuggestInline from './SuggestInline';
import { Props as PropsBase } from './SuggestBase';
import { View } from './types';

const COMPONENT_MAPPER = {
  [View.Default]: SuggestDefault,
  [View.Inline]: SuggestInline,
};

interface Props extends PropsBase {
  view: View;
  className?: string;
}

const Suggest = (props: Props) => {
  const Component = COMPONENT_MAPPER[props.view];

  return <Component {...props} />;
};

Suggest.defaultProps = {
  view: View.Default,
};

Suggest.View = View;

export default Suggest;
