import * as React from 'react';
import Popup from '@crm/components/dist/lego2/Popup';
import SuggestBase from './SuggestBase';
import css from './SuggestDefault.module.css';
import { SuggestDefaultState } from './SuggestDefault.types';
import { directions } from './SuggestDefault.constants';

export default class SuggestDefault extends SuggestBase {
  public state: SuggestDefaultState;

  public render(): React.ReactFragment {
    const { onOutsideClick } = this.props;

    const isShowPopup = this.hasItems();

    return (
      <React.Fragment>
        {this.renderInput(this.props.className)}
        {isShowPopup && (
          <Popup
            visible
            anchor={this.textinputRow}
            onOutsideClick={onOutsideClick}
            zIndex={1000}
            target="anchor"
            directions={directions}
            className={css.popup}
          >
            {this.renderMenu()}
          </Popup>
        )}
      </React.Fragment>
    );
  }
}
