import React from 'react';
import Tags from 'lego/components/Tags';
import cx from 'classnames';
import { WithOId } from 'types';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import { ITextinputProps } from '@yandex-lego/components/Textinput/desktop/bundle';
import { TagBubble } from 'components/TagBubble';
import Suggest from './SuggestContainer';
import css from './SuggestWithTags.scss';
import { GetKey, ItemComponent, TagComponent, View } from './types';
import { ProviderTypes } from '../utils/Provider';

const tag = (props) => props.item.name || null;

export interface Props extends Partial<WithOId> {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onChange: (value: any) => void;
  isSingleValue?: boolean;
  hideSuggestIfSingleValue: boolean;
  isNullEmptyValue?: boolean;
  getKey: GetKey;
  component: ItemComponent;
  tagComponent: TagComponent;
  className?: string;
  size?: LegoSizeProp;
  pin?: ITextinputProps['pin'];
  placeholder?: string;
  autoFocus?: boolean;
  focused?: boolean;
  isCustomValue?: boolean;
  showOnFocus?: boolean;
  provider: ProviderTypes;
  view: View;
  addonAfterTextInput?: React.ReactNode;
}

class SuggestWithTags extends React.Component<Props> {
  public static View = View;

  public static defaultProps = {
    size: 's',
    component: tag,
    tagComponent: tag,
    getKey: (item) => item.id,
    view: View.Default,
    hideSuggestIfSingleValue: true,
  };

  private autoFocus: boolean;

  private handleDelete = (key) => {
    const { onChange, value, getKey, isSingleValue } = this.props;

    let newValue = null;
    if (isSingleValue) {
      this.autoFocus = true;
    } else {
      newValue = (value || []).filter((item) => getKey(item) !== key);
    }

    onChange(newValue);
  };

  private formatValue = (value) => {
    const { isSingleValue } = this.props;

    if (isSingleValue) {
      if (!value) {
        return [];
      }
      if (Array.isArray(value)) {
        return value;
      }
      return [value];
    }

    return value;
  };

  private parseValue = (value) => {
    const { isSingleValue, isNullEmptyValue } = this.props;

    if (isSingleValue) {
      const length = Array.isArray(value) && value.length;
      const lastItem = length && value[length - 1];
      if (lastItem != null) {
        return lastItem;
      }
      if (isNullEmptyValue) {
        return null;
      }

      return undefined;
    }

    return value;
  };

  private handleChange = (value) => {
    const { onChange } = this.props;

    onChange(this.parseValue(value));
  };

  public render() {
    const {
      getKey,
      provider,
      component,
      value,
      className,
      isSingleValue,
      hideSuggestIfSingleValue,
      size,
      pin,
      placeholder,
      autoFocus,
      isCustomValue,
      showOnFocus,
      view,
      addonAfterTextInput,
      oId,
      focused,
    } = this.props;

    const formattedValue = this.formatValue(value);
    const isViewInline = view === View.Inline;

    const hasValue = Array.isArray(value) ? value.length : value;

    const renderedSuggest = !(hideSuggestIfSingleValue && isSingleValue && hasValue) && (
      <Suggest
        key="suggest"
        className={css.b__suggest}
        getKey={getKey}
        provider={provider}
        component={component}
        value={formattedValue}
        onChange={this.handleChange}
        size={size}
        pin={pin}
        placeholder={placeholder}
        autoFocus={autoFocus || this.autoFocus}
        isCustomValue={isCustomValue}
        showOnFocus={showOnFocus}
        view={view}
        addonAfterTextInput={addonAfterTextInput}
        oId={oId}
        focused={focused}
      />
    );

    const renderedTags = Array.isArray(formattedValue) && Boolean(formattedValue.length) && (
      <Tags
        key="tags"
        className={css.b__tags}
        getKey={getKey}
        items={formattedValue}
        onDelete={this.handleDelete}
        component={(props) => (
          <TagBubble
            {...props}
            className={cx(props.className, css.b__tag)}
            canDelete={Boolean(props.onDelete)}
            tag={{
              text: props.item.name || props.item,
              color: props.color,
            }}
          />
        )}
      />
    );

    const content: React.ReactNode[] = [];
    if (isViewInline) {
      content.push(renderedTags);
      content.push(renderedSuggest);
    } else {
      content.push(renderedSuggest);
      content.push(renderedTags);
    }

    return (
      <span
        className={cx(className, { [css[`b_view_${view}`]]: view, [css.b_single]: isSingleValue })}
      >
        {content}
      </span>
    );
  }
}

export default SuggestWithTags;
