import {
  createSyntheticObj,
  EType,
  SyntheticAny,
  SyntheticUser,
  SyntheticUserGroup,
  User,
} from './SuggestStaffBase2';

interface SuggestValue extends User {
  eType: 'User' | 'UserGroup';
  syntheticId: string;
}

interface GrantUser {
  userId: number;
  userName?: string;
}

interface GrantUserGroup {
  groupId: number;
  groupName?: string;
}

const toGrant = (value: SyntheticAny): GrantUser | GrantUserGroup | null => {
  if (!value) {
    return null;
  }

  switch (value.eType) {
    case EType.User: {
      const result: GrantUser = {
        userId: value.id,
        userName: value.name,
      };
      return result;
    }

    case EType.UserGroup: {
      const result: GrantUserGroup = {
        groupId: value.id,
        groupName: value.name,
      };
      return result;
    }

    default:
      return null;
  }
};

function fromGrant(value: GrantUser): SyntheticUser;
function fromGrant(value: GrantUserGroup): SyntheticUserGroup;
function fromGrant(value): SuggestValue | null {
  if (!value) {
    return null;
  }

  if (value.userId) {
    const userValue = value as GrantUser;

    return createSyntheticObj(EType.User, { id: userValue.userId, name: userValue.userName || '' });
  }

  const groupValue = value as GrantUserGroup;
  return createSyntheticObj(EType.UserGroup, {
    id: groupValue.groupId,
    name: groupValue.groupName || '',
  });
}

export default toGrant;
export { fromGrant };
