import * as React from 'react';
import Promise from 'bluebird';
import { baseCallApi } from 'api/common';
import SuggestStaffItem from './SuggestStaffItem';

interface Props {
  onlyActive: boolean;
  // eslint-disable-next-line
  value: any;
  // eslint-disable-next-line
  onChange: (value: any) => void;
}

class SuggestStaffBase extends React.Component<Props> {
  public static defaultProps = {
    onlyActive: false,
  };

  // eslint-disable-next-line
  protected component: React.ComponentType<any> = () => null;

  // eslint-disable-next-line
  private getSuggest = (text?: string): Promise<any> | any[] => {
    const { onlyActive } = this.props;

    if (!text) {
      return [];
    }

    return Promise.delay(650).then(() =>
      baseCallApi({
        url: '/view/staff/user/search',
        data: { text, onlyActive },
        global: false,
      }),
    );
  };

  public render(): React.ReactElement {
    const { onlyActive, ...other } = this.props;

    const Component = this.component;

    return <Component component={SuggestStaffItem} provider={this.getSuggest} {...other} />;
  }
}

export default SuggestStaffBase;
