import * as React from 'react';
import PropTypes from 'prop-types';
import Avatar from 'components/Avatar';
import cx from 'classnames';
import { SuggestUser } from 'types/SuggestUser';
import css from './SuggestStaffItem.scss';

interface Item extends SuggestUser {
  groupName: string;
}

interface Props {
  item: Item;
}

const SuggestStaffItem = (props: Props) => {
  const { item } = props;

  return (
    <span className={cx(css.item)}>
      <Avatar className={css.avatar} user={item} />
      <span className={css.nameRow}>
        <span className={css.name}>{item.name}</span>
        &nbsp;
        <span className={css.login}>@{item.login}</span>
      </span>
      <span className={css.group}>{item.groupName}</span>
    </span>
  );
};

SuggestStaffItem.propTypes = {
  item: PropTypes.instanceOf(Object),
};

SuggestStaffItem.defaultProps = {
  item: {},
};

export default SuggestStaffItem;
