import * as React from 'react';
import PropTypes from 'prop-types';
import Icon from 'lego/components/Icon';
import cx from 'classnames';
import css from './SuggestStaffItem.scss';

interface Item {
  name: string;
  login: string;
  group?: {
    id: number;
    name: string;
  };
}

interface Props {
  item: Item;
}

const SuggestUserGroupItem = (props: Props) => {
  const { item } = props;

  return (
    <span className={cx(css.item)}>
      <span className={cx(css.avatar, css.avatar_icon)}>
        <Icon pack={Icon.PACKS.MATERIAL} icon="group" />
      </span>
      <span className={css.name}>{item.name}</span>
    </span>
  );
};

SuggestUserGroupItem.propTypes = {
  item: PropTypes.instanceOf(Object),
};

SuggestUserGroupItem.defaultProps = {
  item: {},
};

export default SuggestUserGroupItem;
