import * as React from 'react';
import PropTypes from 'prop-types';
import Avatar from 'components/Avatar';
import cx from 'classnames';
import { SuggestUser } from 'types/SuggestUser';
import css from './SuggestStaffItem.scss';

interface Item extends SuggestUser {
  group?: {
    id: number;
    name: string;
  };
}

interface Props {
  item: Item;
}

const SuggestUserItem = (props: Props) => {
  const { item } = props;
  const { group } = item;

  return (
    <span className={cx(css.item)}>
      <Avatar className={css.avatar} user={item} />
      <span className={css.nameRow}>
        <span className={css.name}>{item.name}</span>
        &nbsp;
        <span className={css.login}>@{item.login}</span>
      </span>
      {group && <span className={css.group}>{group.name}</span>}
    </span>
  );
};

SuggestUserItem.propTypes = {
  item: PropTypes.instanceOf(Object),
};

SuggestUserItem.defaultProps = {
  item: {},
};

export default SuggestUserItem;
