import React from 'react';
import cx from 'classnames';
import { ContainerComponent } from './Container.types';
import css from './Container.module.css';

export const Container: ContainerComponent = ({ className, width, testid, ...other }) => {
  return (
    <div data-testid={testid} className={cx(css.Container, css[`Container_width_${width}`], className)} {...other} />
  );
};
